// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

#include "uniformShaderConstants.h"
#include "fragmentVersionSimple.h"
#include "uniformPerFrameConstants.h"

/////////////////////////////////////////////////////////////////
///////////////////////// STOP! /////////////////////////////////
/////////////////////////////////////////////////////////////////
// Made by @Bicubicpack.
// successfully changed (modified and optimalized) on 7 oct 2020.
// all of these assets are under MIT license.
/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////

varying highp vec3 pos;

vec3 skycolor(in float lenpos){
	highp vec2 ftime = vec2(pow(max(min(1.0-FOG_COLOR.r*1.5,1.),.0),1.2),pow(max(min(1.0-FOG_COLOR.r*1.2,1.),.0),.5));
	float dark= (1.-FOG_COLOR.b)*clamp((FOG_COLOR.r-.15)*1.2,0.,1.);
	float rain = (1. - pow(FOG_CONTROL.y, 10.));

	vec3 skycolor = mix(vec3(.47,.65,.93),vec3(.4,.6,.9)*.34,ftime.x);
		skycolor = mix(skycolor,vec3(0,0.2,0.6),dark);
		skycolor = mix(skycolor,FOG_COLOR.rgb*1.5,rain);

	vec3 scattercolor = mix(FOG_COLOR.rgb,FOG_COLOR.rgb+vec3(FOG_COLOR.r,FOG_COLOR.g,FOG_COLOR.b*2.)*1.2,min(dark*ftime.y*3.,1.));
		scattercolor = mix(scattercolor,FOG_COLOR.rgb*1.3,rain);

if(FOG_CONTROL.x == 0.){
return FOG_COLOR.rgb;
} else {
return mix(skycolor,scattercolor,smoothstep(0.,.9,lenpos));
}
}

void main(){

	highp float lp = length(pos.xz);
	vec3 result = skycolor(lp);
gl_FragColor = vec4(result, FOG_COLOR.a);

}
